function [residual, g1, g2, g3] = FiscalRE16022017_correct_tax_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [nperiods by M_.exo_nbr] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   steady_state  [M_.endo_nbr by 1] double       vector of steady state values
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations.
%                                          Dynare may prepend auxiliary equations, see M_.aux_vars
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence followed by the ones in M_.exo_names
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(15, 1);
T74 = (1-params(8))/params(10);
T105 = params(8)*params(9)*params(12)*(1-params(16))/params(10)^params(2);
T129 = params(13)*params(15)/params(10);
T135 = params(17)*params(16)*(params(8)*params(9)-params(8))/params(10);
T163 = params(15)*params(21)/params(10);
residual(1) = y(9)-(params(1)-(params(2)-1)/params(2)*params(3))*y(5)-y(4);
lhs =y(9);
rhs =y(3)-y(5);
residual(2)= lhs-rhs;
lhs =y(16);
rhs =y(15)-y(3);
residual(3)= lhs-rhs;
lhs =y(17);
rhs =y(2)-y(3);
residual(4)= lhs-rhs;
lhs =y(8);
rhs =y(3)+x(it_, 1)-y(1)-y(12);
residual(5)= lhs-rhs;
lhs =y(3);
rhs =y(4)*params(4)+params(5)*y(7)+y(15)*params(6);
residual(6)= lhs-rhs;
lhs =y(3);
rhs =y(1)*params(7)+y(5)*(1-params(7))-x(it_, 1)*params(7)+y(12)*params(7);
residual(7)= lhs-rhs;
residual(8) = y(12)*(-params(8))*params(9)/params(10)-y(6)+y(7)*params(11)-x(it_, 1)*T74+y(1)*T74;
residual(9) = y(12)+(-y(8))/(params(9)-1);
lhs =y(10);
rhs =y(3)-y(5);
residual(10)= lhs-rhs;
lhs =y(4)*(-params(2))-y(5)*params(3)*(1-params(2));
rhs =(-params(2))*y(18)-params(3)*(1-params(2))*y(19)+T105*y(20);
residual(11)= lhs-rhs;
lhs =y(11);
rhs =y(8)*(1-params(16))*params(8)*params(9)/params(13);
residual(12)= lhs-rhs;
residual(13) = params(14)*y(13)-params(15)*y(14)-y(6)*params(17);
residual(14) = y(15)*params(6)+T129*(y(2)+y(11))-y(1)*T135-y(8)*params(8)*params(9)*params(17)*params(16)/params(10)-(1-params(7))*params(18)*(y(9)+y(5))+x(it_, 1)*(T135-T129)-params(15)*y(14)-y(4)*params(4)*params(19);
residual(15) = y(3)*(params(6)+params(20)-T163)+T163*(y(2)-x(it_, 1))+x(it_, 2)-y(15)*params(6);
if nargout >= 2,
  g1 = zeros(15, 22);

  %
  % Jacobian matrix
  %

  g1(1,4)=(-1);
  g1(1,5)=(-(params(1)-(params(2)-1)/params(2)*params(3)));
  g1(1,9)=1;
  g1(2,3)=(-1);
  g1(2,5)=1;
  g1(2,9)=1;
  g1(3,3)=1;
  g1(3,15)=(-1);
  g1(3,16)=1;
  g1(4,3)=1;
  g1(4,2)=(-1);
  g1(4,17)=1;
  g1(5,3)=(-1);
  g1(5,1)=1;
  g1(5,8)=1;
  g1(5,12)=1;
  g1(5,21)=(-1);
  g1(6,3)=1;
  g1(6,4)=(-params(4));
  g1(6,7)=(-params(5));
  g1(6,15)=(-params(6));
  g1(7,3)=1;
  g1(7,5)=(-(1-params(7)));
  g1(7,1)=(-params(7));
  g1(7,12)=(-params(7));
  g1(7,21)=params(7);
  g1(8,1)=T74;
  g1(8,6)=(-1);
  g1(8,7)=params(11);
  g1(8,12)=(-params(8))*params(9)/params(10);
  g1(8,21)=(-T74);
  g1(9,8)=(-1)/(params(9)-1);
  g1(9,12)=1;
  g1(10,3)=(-1);
  g1(10,5)=1;
  g1(10,10)=1;
  g1(11,4)=(-params(2));
  g1(11,18)=params(2);
  g1(11,5)=(-(params(3)*(1-params(2))));
  g1(11,19)=params(3)*(1-params(2));
  g1(11,20)=(-T105);
  g1(12,8)=(-((1-params(16))*params(8)*params(9)/params(13)));
  g1(12,11)=1;
  g1(13,6)=(-params(17));
  g1(13,13)=params(14);
  g1(13,14)=(-params(15));
  g1(14,4)=(-(params(4)*params(19)));
  g1(14,5)=(-((1-params(7))*params(18)));
  g1(14,1)=(-T135);
  g1(14,8)=(-(params(8)*params(9)*params(17)*params(16)/params(10)));
  g1(14,9)=(-((1-params(7))*params(18)));
  g1(14,11)=T129;
  g1(14,2)=T129;
  g1(14,14)=(-params(15));
  g1(14,15)=params(6);
  g1(14,21)=T135-T129;
  g1(15,3)=params(6)+params(20)-T163;
  g1(15,2)=T163;
  g1(15,15)=(-params(6));
  g1(15,21)=(-T163);
  g1(15,22)=1;

if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],15,484);
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],15,10648);
end
end
end
end
